package com.ejie.p06b.ejb;

import java.sql.SQLException;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import com.ejie.p06b.log.P06BLog;

import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.ejb.EJBException;


import com.ejie.p06b.message.P06bProcessMessage;

/**
 * Message-Driven Bean implementation class for: P06bMDB
 *
 */
/*
 * @MessageDriven(
		activationConfig = { @ActivationConfigProperty(
				propertyName = "destinationType", propertyValue = "javax.jms.Queue"
					
		) })
*/
		
@MessageDriven(activationConfig = { @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, name = "p06b.P06bMDB", mappedName = "p06b.p06bJMSQueue")
@TransactionManagement(TransactionManagementType.CONTAINER)
@TransactionAttribute()
public class P06bMDB implements MessageDrivenBean, MessageListener {

	private static final long serialVersionUID = 9024477501616726159L;
	
	/** The MessageDrivenContext */
    private MessageDrivenContext context;

    /**
     * Default constructor. 
     */
    public P06bMDB() {
        // TODO Auto-generated constructor stub
    }
	
    public void ejbRemove() throws EJBException {
        // TODO Auto-generated method stub

    }
    
    /**
     * Set the associated context. The container calls this method 
     * after the instance creation.  <br>
     * 
     * The enterprise bean instance should store the reference to the context 
     * object in an instance variable. <br>
     * 
     * This method is called with no transaction context.
     * 
     * @param newContext A MessageDrivenContext interface for the instance. 
     * 
     * @throws EJBException Thrown by the method to indicate a failure caused by a system-level error.
     */
    public void setMessageDrivenContext(MessageDrivenContext newContext)
        throws EJBException {
        context = newContext;
    }

    /**
     * Cmo generar fichero descriptor (xsd) a partir de su fichero xml asociado: http://www.freeformatter.com/xsd-generator.html#ad-output
     * 
     * Generar clase java a partir de su fichero descriptor (xsd) utilizando XMLBeans:
     * 	- Instalar XMLBeans: http://xmlbeans.apache.org/documentation/tutorial_getstarted.html
     *  - Configurar las variables de entorno en Windows: http://xmlbeans.apache.org/documentation/conInstallGuide.html
     *  - Generar la librera a partir del fichero descriptor asociado (xsd):
     *    scomp -out NotificationBody.jar NotificationBody.xsd
     *    scomp -out NotificationCData.jar NotificationCData.xsd
     *    scomp -out ejgvDocument.jar ejgvDocument.xsd
     *  - Parsear en cdigo Java el XML requerido con ayuda de esta librera generada: 
     *  
     *  
     *  Cmo generar fichero descriptor (xsd) a partir de su fichero xml asociado:HYPERLINK "http://www.freeformatter.com/xsd-generator.html"http://www.freeformatter.com/xsd-generator.html#ad-output
 * Cmo generar las clases Java de parseo de un fichero descriptor (xsd):http://blog.sanaulla.info/2010/08/29/using-jaxb-to-generate-xml-from-the-java-xsd/
 *  (para evitar errores del tipo '' y forzar a que no cree la clase '' se debe lanzar con la propiedad '-npa':https://www.java.net/node/644185
 * D:\DATOS\glopezri\Desktop\BASURA\Nueva(file:///D:/DATOS/glopezri/Desktop/BASURA/Nueva)carpeta (2)>"C:\bea\weblogic1035\jrockit_160_24_D1.1.2-4\bin\xjc" -npa sample.xml              
 * Cmo parsear un XML a un objeto Java (previamnete generado):http://www.mkyong.com/java/jaxb-hello-world-example/
 * Problema: Etiquetas/subetiquetas con el mismo nombre (por ejemplo, etiqueta <Contingencias>): Se debe reemplazar la definciin de clase de una de ellas por otro nombre (por ejemplo, ContingenciasJub)

     * Comunicacin con WS de X43
     *  - Generar librera cliente de WS X43 para su comunicacin utilziando la tarea clientgen de Ant (en local)
     *    a) Instalar Apache Ant en local
     *    b) Configurar las variables para que apunten a la instalacin en local (ficheros build.xml y build-ejie.xml de carpeta ejie)
     *    	<project name="buildWebservice" default="generar_cliente">
 	 *			<target name="generar_cliente">             
   	 * 			<clientgen 
   	 * 				wsdl="http://svc.intra.integracion.jakina.ejiedes.net/ctxapp/X43Toolkit?WSDL"
   	 *				packageName="com.ejie.r76b.x43.wsclient"
   	 *				clientJar="x43_client.jar"/>
   	 * 				</target>
	 *	 	 </project>
     *    c) Ejecutar el bat de definicin de variables locales (ejie/setEnvEjie.cmd)
     *    d) Ejecutar el comando de generacin de librera (se debe estar en la misma ubicacin dnde hemos guardado nuestro build.xml)
     *    		ant -logfile build.log
     *    e) 
     *    Para ms informacin, ver documento D:\DATOS\glopezri\Desktop\Documentacin\01 Hacienda\R76 - TEAE\01 Integracin con Tramitagune\Gua de Uso - Nuevo Sistema Horizontal de Firma (1).doc
     */
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message msg){
    	P06BLog.send(0,this, "(onMessage) Nuevo evento capturado");
    	new P06bProcessMessage(msg).onMessage();		
     	P06BLog.send(0,this, "(onMessage) Fin evento capturado");
    }

    /**
     * An ejbCreate method as required by the EJB specification.
     * 
     * The container calls the instance?s <code>ejbCreate</code> method 
     * immediately after instantiation.
     * 
     * @ejb.create-method
     */
    public void ejbCreate() {
    }
    
}
